unit PresentEditor35;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls,
  Dialogs, ComCtrls, StdCtrls, ExtCtrls, ExtDlgs, JPEG,
  MainData, Present35, AboutMain;
// =========================================================================
// =========================================================================
//
// =========================================================================
// =========================================================================

type TPresentationEditor = class(TPresentation)
private
   // ------------------
   //  
   fImage               : TImage;
   fTreeView            : TTreeView;
   fSlideSizeIndx       : integer;    //    
   // ------------------
   //      
   //    TreeView
   // ( Root   nil)
   function AddNodeToEnd(RqParent : TTreeNode;
                         RqTitle  : string;
                         RqUnSel, RqSel : integer) : TTreeNode;  overload;
   //      
   //    TreeView ( )
   // ( Root   nil)
   function AddNodeToEnd(RqTree   : TTreeView;
                         RqParent : TTreeNode;
                         RqTitle  : string;
                         RqUnSel,
                         RqSel    : integer) : TTreeNode;  overload;
   // ------------------
   //  Pictures.BitMap  JPEG     
   function SaveJpegToFile (RqFileName    : string;
                            RqPicture     : TPicture) : boolean;
   //    c  RqNumb
   procedure DrawSlideTemplateN(RqPicture : TPicture; RqNumb : integer);
   //        ( 1)
   procedure DrawSlideTemplate1(RqPicture : TPicture);
   //   
   function BuildSlideImage(RqSilideDir : string; RqNumb : integer) : boolean;
   //    
   function NewSlidesTree(RqTree   : TTreeView;
                          RqTopDir : string;
                          RqPresentationName : string) : boolean;
   // ------------------
   //      ,
   //       
   function NewSubFolder(RqTopDir, RqSubDir : string) : boolean;
   //     
   function BuildFolderSubTree(RqTopDir : string) : boolean;
public
   constructor Create(RqImage     : TImage;
                      RqTreeView  : TTreeView;
                      RqStatusBar : TStatusBar);
   procedure Free();
   // ------------------
   //     *.jpg   MainImage
   procedure AddMainImageDialog();
   //     *.jpg   Image
   procedure AddImageDialog();
   //     *.*   Video  Docum
   procedure AddFileDialog();
   // ------------------
   //   
   procedure DeleteSelectFile();
   // ------------------
   // ,      
   function NewPresentation(RqApplicationDir   : string;
                            RqPresentationName : string) : boolean;
   //   
   procedure ReSavePresentation();
   // ------------------
   //   ComboBox    
   procedure BuildSlideSizeBox(RqComboBox : TComboBox);
   // ------------------
   //       
   property SlideSizeIndx : integer read fSlideSizeIndx write fSlideSizeIndx;
end;



implementation

const GridWidth = 4;      //     

// =========================================================================
//      TPresentationEditor
// =========================================================================
// =========================================================================
// -------------------------------------------------------------------------
const MaxSlides = 13;          //     
//      
const SlideBoxArr : array[0..7] of record
  Txt  : string;
  W, H : integer
end  =
( (Txt : '800 * 600';   W : 800;  H : 600),
  (Txt : '1024 * 768';  W : 1024; H : 768 ),
  (Txt : '1152 * 864';  W : 1152; H : 864),
  (Txt : '1280 * 960';  W : 1280; H : 960),
  (Txt : '1280 * 1024'; W : 1280; H : 1024),
  (Txt : '1600 * 900';  W : 1600; H : 900),
  (Txt : '1680 * 1050'; W : 1680; H : 1050),
  (Txt : '1920 * 1080'; W : 1920; H : 1080)
);

// =========================================================================
//     TPresentationEditor
// =========================================================================
// -------------------------------------------------------------------------
// 27.10.2016
constructor TPresentationEditor.Create
                                (RqImage     : TImage;
                                 RqTreeView  : TTreeView;
                                 RqStatusBar : TStatusBar);
begin
    if Assigned(RqImage)    and
       Assigned(RqTreeView) and
       Assigned(RqStatusBar)
    then begin
       inherited Create(RqImage, RqTreeView, RqStatusBar);
       fImage := RqImage;
       fTreeView := RqTreeView;
    end;
end;
// -------------------------------------------------------------------------
// 27.10.2016
procedure TPresentationEditor.Free();
begin
   inherited Free;
end;

// =========================================================================
//    TPresentationEditor
// =========================================================================
// -------------------------------------------------------------------------
// 27.10.2016
//       ( Root   nil)
//  OVERLOAD
function TPresentationEditor.AddNodeToEnd
                     (RqParent : TTreeNode;
                      RqTitle  : string;
                      RqUnSel, RqSel : integer) : TTreeNode;
begin
   Result := nil;
   if not Assigned(fTreeView) then Exit;
   with fTreeView.Items do
   begin
      BeginUpdate;
         Result := AddChild(RqParent,RqTitle);
         Result.ImageIndex    := RqUnSel;
         Result.SelectedIndex := RqSel;
      EndUpdate;
      fTreeView.Refresh;
   end;
end;
// -------------------------------------------------------------------------
// 30.10.2016
//       ( Root   nil)
//  OVERLOAD
function TPresentationEditor.AddNodeToEnd(RqTree   : TTreeView;
                                          RqParent : TTreeNode;
                                          RqTitle  : string;
                                          RqUnSel,
                                          RqSel    : integer) : TTreeNode;
begin
   Result := nil;
   if not Assigned(RqTree) then Exit;
   with RqTree.Items do
   begin
      Result := AddChild(RqParent,RqTitle);
      Result.ImageIndex := RqUnSel;
      Result.SelectedIndex := RqSel;
   end;
end;

// =========================================================================
//        TPresentationEditor
// =========================================================================
// -------------------------------------------------------------------------
// 30.10.2016
//  Pictures.BitMap  JPEG     
function TPresentationEditor.SaveJpegToFile
                            (RqFileName : string;
                             RqPicture  : TPicture) : boolean;
var JI  : TJpegImage;       //  
begin
  Result := False;
  if (RqFileName <> '') and Assigned(RqPicture.Bitmap)
  then begin
     //   
     JI := TJpegImage.Create;
     try
        JI.PixelFormat := jf24bit;         //    
        JI.CompressionQuality := 100;      // 100  
        JI.ProgressiveEncoding := False;
        JI.Assign(RqPicture.Bitmap);
        JI.SaveToFile(RqFileName);
        Result := True;
     except
        MessageDlg('      '
        +  #13#10 + RqFileName
        +  #13#10 + '  ',
        mtError, [mbOk], 0);
     end;
     //   
     if Assigned(JI) then JI.Free;
  end;
end;
// -------------------------------------------------------------------------
// 30.10.2016
//    c  RqNumb
procedure TPresentationEditor.DrawSlideTemplateN(RqPicture : TPicture;
                                                 RqNumb    : integer);
begin
  with RqPicture.Bitmap.Canvas
  do begin
     //  
     Brush.Style := bsClear;
     Font.Name := 'Arial';
     Font.Size := 10;
     Font.Style := [fsBold, fsItalic];
     Font.Color := clBlack;
     TextOut(30, 30, ' ' + IntToStr(RqNumb));
  end;
end;
// -------------------------------------------------------------------------
// 30.10.2016
//        ( 1)
procedure TPresentationEditor.DrawSlideTemplate1(RqPicture : TPicture);
const TitleArr : array[1..4] of string =
( '  ',
  '        ',
  '   ',
  '  .'
);
const Title1Arr : array[1..3] of string =
(  '         1',
  '      ',
  '  .'
);
var PicHeight, PicWidth : integer;
    RowH, ColW  : integer;
    RInd, CInd  : integer;
    Numb, TextH : integer;
    Ind         : integer;
begin
  PicHeight := RqPicture.Bitmap.Height;
  PicWidth  := RqPicture.Bitmap.Width;
  with RqPicture.Bitmap.Canvas
  do begin
    RowH := Trunc(PicHeight / 4);
    ColW := Trunc(PicWidth  / 4);
    Pen.Width := GridWidth;
    Pen.Color := clWhite;
    Pen.Style := psSolid;
    //  
    for RInd := 1 to 3
    do begin
       MoveTo(0,        RInd * RowH);
       LineTo(PicWidth, RInd * RowH);
       for CInd := 1 to 3
       do begin
          MoveTo(CInd * ColW, 0);
          LineTo(CInd * ColW, PicWidth);
       end;
    end;
    //     
    Brush.Style := bsSolid;
    Brush.Color := RGB(131,153,177);
    FillRect(Rect(ColW + Pen.Width - 2,
                  RowH + Pen.Width - 2,
                  3 * ColW - 2,
                  3 * RowH - 2));
    //  
    Brush.Style := bsClear;
    Font.Name := 'Arial';
    Font.Size := 10;
    Font.Style := [fsBold, fsItalic];
    Font.Color := clBlack;
    //    
    Numb := 2;
    for RInd := 0 to 3
    do begin
       for CInd := 0 to 3
       do begin
          if not ((RInd >= 1) and (RInd <= 2) and (CInd >= 1) and (CInd <= 2))
          then begin
             TextH := RInd * RowH + 10;
             for Ind := Low(TitleArr) to High(TitleArr)
             do begin
                //   
                if Ind = 2  //   
                then TextOut(CInd * ColW + 10, TextH, TitleArr[Ind]
                                                    + IntToStr(Numb))
                else TextOut(CInd * ColW + 10, TextH, TitleArr[Ind]);
                TextH := TextH + TextHeight('1') + 10;
             end;
             Numb := Numb + 1;
          end;
       end;
    end;
    //    1
    Font.Size := 12;
    Font.Style := [fsBold];
    TextH := RowH + 30;
    for Ind := Low(Title1Arr) to High(Title1Arr)
    do begin
       //   
       TextOut(ColW + 30, TextH, Title1Arr[Ind]);
       TextH := TextH + TextHeight('1') + 10;
    end;
  end;
end;

// -------------------------------------------------------------------------
// 30.10.2016
//   
function TPresentationEditor.BuildSlideImage(RqSilideDir : string;
                                             RqNumb : integer) : boolean;
var wPicture : TPicture;
    wW, wH   : integer;
begin
   Result := False;
   if not DirectoryExists(RqSilideDir) then Exit;
   //  
   //   
   if not ((fSlideSizeIndx >= Low(SlideBoxArr)) and
           (fSlideSizeIndx <= High(SlideBoxArr)))
    then fSlideSizeIndx := 1;
   wW := SlideBoxArr[fSlideSizeIndx].W;
   wH := SlideBoxArr[fSlideSizeIndx].H;
   //  
   wPicture := TPicture.Create;
   try
      wPicture.Bitmap.PixelFormat := pf24bit;
      wPicture.Bitmap.Width  := wW;
      wPicture.Bitmap.Height := wH;
      with wPicture.Bitmap.Canvas
      do begin
         Pen.Width := GridWidth;
         Pen.Color := clWhite;
         Pen.Style := psSolid;
         Brush.Color := RGB(131,153,177);
         Brush.Style := bsSolid;
         Rectangle(Rect(0,0,wW,wH));
      end;
      //    
      if RqNumb = 1
      then DrawSlideTemplate1(wPicture)
      else DrawSlideTemplateN(wPicture, RqNumb);

      if  DirectoryExists(RqSilideDir)
      then begin
         //      
         SaveJpegToFile(RqSilideDir
                     + '\Slide'
                     + IntToStr(RqNumb)
                     + '.jpg', wPicture);
         Result := True;
      end;
   finally
      wPicture.Free;
   end;
end;
// -------------------------------------------------------------------------
// 30.10.2016
//    
function TPresentationEditor.NewSlidesTree
                            (RqTree   : TTreeView;
                             RqTopDir : string;
                             RqPresentationName : string) : boolean;
var   RootNode, Level1, Level2 : TTreeNode;
      Ind : integer;
begin
  Result := False;
  if not Assigned(RqTree) then Exit;
  //  
  Result := True;
  //     TreeView
  RqTree.Items.Clear;
  //   TreeView -  (Level = 0)
  RootNode := RqTree.Items.Add(nil, RqPresentationName);
  for Ind := 1 to MaxSlides
  do begin
     //  TreeView -  (Level = 1)   
     Level1 := AddNodeToEnd(RqTree, RootNode,
                           ' ' + IntToStr(Ind),
                            Lv1UnSelImg, Lv1SelImg);
     //    
     Level2 := AddNodeToEnd(RqTree, Level1, NodeMainImg, Lv2UnSelImg, Lv2SelImg);
     //  TreeView -     
     AddNodeToEnd(RqTree, Level2, 'Slide' + IntToStr(Ind) + '.jpg', -1, -1);
     //  jpg -  
     if BuildSlideImage(RqTopDir + '\' + NodeMainImg, Ind)
     then begin
        //       
        AddNodeToEnd(RqTree, Level1, NodeImage, Lv2UnSelImg, Lv2SelImg);
        AddNodeToEnd(RqTree, Level1, NodeVideo, Lv2UnSelImg, Lv2SelImg);
        AddNodeToEnd(RqTree, Level1, NodeDocum, Lv2UnSelImg, Lv2SelImg);
     end
     else begin
        Result := False;
        Break;
     end
  end;
end;

// -------------------------------------------------------------------------
// 30.10.2016
//      ,
//       
function TPresentationEditor.NewSubFolder
                            (RqTopDir, RqSubDir : string) : boolean;
begin
  Result := True;
  //      
  if not DirectoryExists(RqTopDir)
  then if not ForceDirectories (RqTopDir) then Result := False;
  //    
  if Result
  then if not DirectoryExists(RqTopDir + '\' + RqSubDir)
       then if not ForceDirectories (RqTopDir + '\' + RqSubDir)
            then begin
               Result := False;
               MessageDlg('     '
              +  #13#10 + RqTopDir + '\' + RqSubDir
              +  #13#10 + '  ',
               mtError, [mbOk], 0);
            end;
end;
// -------------------------------------------------------------------------
// 30.10.2016
//     
function TPresentationEditor.BuildFolderSubTree(RqTopDir : string) : boolean;
begin
   Result := False;
   if not NewSubFolder(RqTopDir, NodeMainImg) then Exit;
   if not NewSubFolder(RqTopDir, NodeImage)   then Exit;
   if not NewSubFolder(RqTopDir, NodeVideo)   then Exit;
   if not NewSubFolder(RqTopDir, NodeDocum)   then Exit;
   Result := True;
end;
// -------------------------------------------------------------------------
// 30.10.2016
// ,      
function TPresentationEditor.NewPresentation
                            (RqApplicationDir   : string;
                             RqPresentationName : string) : boolean;
var  wPresentDir : string;
     wFileName   : string;
     wTree       : TTreeView;
begin
  Result := False;
  if (RqPresentationName = '') or (RqApplicationDir = '') then Exit;
  //  
  wPresentDir := RqApplicationDir + '\' + RqPresentationName;
  //    
  if DirectoryExists(wPresentDir)
  then begin
     if MessageDlg('   :'
         + #13#10 + RqPresentationName
         + #13#10 + '   '
         + #13#10 + '   ?',
         mtConfirmation, [mbYes, mbNo], 0) = mrCancel
     then Exit;
  end;
  //  
  // ---------------------
  //       
  if not BuildFolderSubTree(wPresentDir) then Exit;
  // ---------------------
  //  ,  TreeView
  wTree := TTreeView.Create(fTreeView.Parent);
  wTree.Parent  := fTreeView.Parent;
  wTree.Visible := False;
  //    
  wFileName := wPresentDir
       + '\' + RqPresentationName
       + '.' + PresentExtName;
  //   TreeView-
  if NewSlidesTree(wTree, wPresentDir, RqPresentationName)
  then begin
     try
       //    
       wTree.SaveToFile(wFileName);  //  
       Result := True;               //   
     except
       MessageDlg('    '
       +  #13#10 + wFileName
       +  #13#10 + '  ',
        mtError, [mbOk], 0);
     end;
  end;
  //  ,  TreeView
  if Assigned (wTree) then wTree.Free;
  //     
  if Result then LoadPresentation(RqApplicationDir, RqPresentationName);
end;

// =========================================================================
//          TPresentationEditor
// =========================================================================
// -------------------------------------------------------------------------
// 27.10.2016
//     *.jpg   MainImage
procedure TPresentationEditor.AddMainImageDialog();
var wItemName : string;
    wSelectNode : TTreeNode;
    wDialog : TOpenPictureDialog;
    wFileName : string;
begin
    if not Assigned(fTreeView) then Exit;
    wSelectNode := fTreeView.Selected;
    if not Assigned(wSelectNode) then Exit;
    wItemName := wSelectNode.Text;
    if not ((wSelectNode.Level = 2) and
            (wItemName = NodeMainImg))
    then begin
       MessageDlg('       ' + NodeMainImg,
                  mtInformation, [mbOk], 0);
       Exit;
    end;
    if (wSelectNode.Count > 0)
    then begin
       MessageDlg('    ' + NodeMainImg
                +  #13#10
                + '     ',
                  mtInformation, [mbOk], 0);
       Exit;
    end;
    //  
    wDialog := TOpenPictureDialog.Create(nil);
    wDialog.Filter := 'JPEG Image File |*.jpg;*.jpeg';
    wDialog.InitialDir := FullPesentDir + '\' + NodeMainImg;
    if wDialog.Execute
    then begin
      wFileName := ExtractFileName(wDialog.FileName);
      if AddNodeToEnd(wSelectNode, wFileName, -1, -1) <> nil
      then wSelectNode.Expand(False);
      //   
      BuildSlideList;
    end;
end;
// -------------------------------------------------------------------------
// 27.10.2016
//     *.jpg   Image
procedure TPresentationEditor.AddImageDialog();
var wItemName : string;
    wSelectNode : TTreeNode;
    wDialog : TOpenPictureDialog;
    wFileName : string;
begin
    if not Assigned(fTreeView) then Exit;
    wSelectNode := fTreeView.Selected;
    if not Assigned(wSelectNode) then Exit;
    wItemName := wSelectNode.Text;
    if not ((wSelectNode.Level = 2) and
            (wItemName = NodeImage))
    then begin
       MessageDlg('       ' + NodeImage,
                  mtInformation, [mbOk], 0);
       Exit;
    end;
    //  
    wDialog := TOpenPictureDialog.Create(nil);
    wDialog.Filter := 'JPEG Image File |*.jpg;*.jpeg';
    wDialog.InitialDir := FullPesentDir + '\' + NodeImage;
    if wDialog.Execute
    then begin
      wFileName := ExtractFileName(wDialog.FileName);
      if AddNodeToEnd(wSelectNode, wFileName, -1, -1) <> nil
      then wSelectNode.Expand(False);
    end;
end;

// -------------------------------------------------------------------------
// 28.10.2016
//     *.*   Video  Docum
procedure TPresentationEditor.AddFileDialog();
var wItemName : string;
    wSelectNode : TTreeNode;
    wDialog : TOpenDialog;
    wFileName : string;
begin
    if not Assigned(fTreeView) then Exit;
    wSelectNode := fTreeView.Selected;
    if not Assigned(wSelectNode) then Exit;
    wItemName := wSelectNode.Text;
    if not((wSelectNode.Level = 2) and
           ((wItemName = NodeVideo) or
            (wItemName = NodeDocum)))
    then begin
       MessageDlg('    '
       + #13#10 + '  ' + NodeVideo + '  ' + NodeDocum,
                  mtInformation, [mbOk], 0);
       Exit;
    end;
    //  
    wDialog := TOpenDialog.Create(nil);
    wDialog.Filter := 'All File |*.*';
    wDialog.InitialDir := FullPesentDir + '\' + NodeImage;
    if wDialog.Execute
    then begin
      wFileName := ExtractFileName(wDialog.FileName);
      if AddNodeToEnd(wSelectNode, wFileName, -1, -1) <> nil
      then wSelectNode.Expand(False);
    end;
end;

// -------------------------------------------------------------------------
// 27.10.2016
//   
procedure TPresentationEditor.DeleteSelectFile();
var wItemName    : string;
    wSelectNode  : TTreeNode;
begin
    if not Assigned(fTreeView) then Exit;
    wSelectNode := fTreeView.Selected;
    if not Assigned(wSelectNode) then Exit;
    wItemName := wSelectNode.Text;
    if (wSelectNode.Level = 3)
    then begin
       if MessageDlg('      :'
                    + #13#10 + wItemName
                    + #13#10 + '  ?',
                    mtConfirmation, [mbYes, mbNo], 0) = mrYes
       then begin
           if (wSelectNode.Parent.Text = NodeMainImg)
           then begin
              //      
              fTreeView.Items.BeginUpdate;
                 wSelectNode.Delete;
              fTreeView.Items.EndUpdate;
              //   
              BuildSlideList;
              //     
              ImageClear();
           end
           else begin
              //     
              fTreeView.Items.BeginUpdate;
                 wSelectNode.Delete;
              fTreeView.Items.EndUpdate;
              fTreeView.Refresh;
           end;
       end;
    end
     else begin
       MessageDlg('     '
       + #13#10 + '  ,    ...',
       mtInformation, [mbNo], 0)
    end;
end;

// -------------------------------------------------------------------------
// 30.10.2016
//   
procedure TPresentationEditor.ReSavePresentation();
begin
   if not Assigned(fTreeView)         then Exit;
   if not Assigned(fTreeView.TopItem) then Exit;
   if (FullPresentFileName <> '') and (fTreeView.TopItem.Count > 0)
   then begin
     try
        fTreeView.SaveToFile(FullPresentFileName);
        MessageDlg('     :'
         + #13#10 + FullPresentFileName,
         mtInformation, [mbOk], 0);
     except
        MessageDlg('     :'
         + #13#10 + FullPresentFileName,
         mtError, [mbOk], 0);
     end;
   end;
end;

// -------------------------------------------------------------------------
// 31.10.2016
//   ComboBox    
procedure TPresentationEditor.BuildSlideSizeBox(RqComboBox : TComboBox);
var Ind : integer;
begin
   if not Assigned(RqComboBox) then Exit;
   RqComboBox.Clear;
   for Ind := Low(SlideBoxArr) to High(SlideBoxArr)
   do RqComboBox.Items.Add(SlideBoxArr[Ind].Txt);
   RqComboBox.ItemIndex := 1;
end;

// =========================================================================
//    TPresentationEditor
// =========================================================================


end.
